SELECT KCU.TABLE_SCHEMA, KCU.TABLE_NAME, KCU.CONSTRAINT_NAME,
       C.COLUMN_NAME, C.DATA_TYPE
FROM   INFORMATION_SCHEMA.KEY_COLUMN_USAGE AS KCU
       INNER JOIN INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS AS RC
             ON KCU.CONSTRAINT_SCHEMA = RC.CONSTRAINT_SCHEMA
                AND KCU.CONSTRAINT_NAME = RC.CONSTRAINT_NAME
       INNER JOIN INFORMATION_SCHEMA.COLUMNS AS C
             ON KCU.TABLE_SCHEMA = C.TABLE_SCHEMA
                AND KCU.TABLE_NAME = C.TABLE_NAME
                AND KCU.COLUMN_NAME = C.COLUMN_NAME
WHERE  DATA_TYPE = 'datetime';